﻿using SolviaOneDriveKillerLib;
using SolviaOneDriveKillerLib.Entities;
using SolviaOneDriveKillerLib.Helpers;
using System;
using System.IO;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace SolviaOneDriveKillerUser
{
    public partial class FormMain : Form
    {
        public const string JobFileJson = @"C:\solvia\job.json";
        public const string JobFileXml = @"C:\solvia\job.xml";
        public FormMain()
        {
            InitializeComponent();
            this.Shown += FormMain_Shown;
        }

        private void FormMain_Shown(object sender, EventArgs e)
        {
            string uninstallString = WindowsRegistry.GetOneDriveUninstallStringUser();
            textBox1.Text = WindowsRegistry.GetOneDriveUninstallStringUser();
            Logging.SendToLog($"Uninstall string: {uninstallString}");
            string path = HelperFunctions.ExtractPathFromCommandLine(textBox1.Text);
            //if (WindowsRegistry.DeleteOneDriveFromRegistry()) { 
            //    ExplorerRestarter.RestartExplorer();
            //}
        }

        private void btnUninstall_Click(object sender, EventArgs e)
        {
            string s = WindowsRegistry.GetOneDriveUninstallStringUser();
            if (string.IsNullOrEmpty(s))
            {
                Logging.SendToLog($"OneDrive uninstall string: {s}");
                return;
            }
            else
            {
                Logging.SendToLog($"OneDrive uninstall string: {s}");
                string path = HelperFunctions.ExtractPathFromCommandLine(s);
                Logging.SendToLog($"Path: {path}");
                string args = HelperFunctions.ExtractArgumentsFromCommandLine(s, path);
                Logging.SendToLog($"Args: {args}");

                CustomCommand command = new CustomCommand
                {
                    Command = HelperFunctions.ExtractPathFromCommandLine(s),
                    Arguments = HelperFunctions.ExtractArgumentsFromCommandLine(s, HelperFunctions.ExtractPathFromCommandLine(s))
                };

                // serial command to json and save it in c:\job.json
                string json = Newtonsoft.Json.JsonConvert.SerializeObject(command);

                try
                {
                    if (!Directory.Exists(@"c:\Solvia")) Directory.CreateDirectory(@"c:\Solvia");
                    System.IO.File.WriteAllText(JobFileJson, json);
                    var ret = WindowsProcess.ExecuteCommand(path, args + @" /silent", true);
                    Logging.SendToLog($"UninstallOneDrive: {ret}");

                }
                catch (Exception ex)
                {
                    Logging.SendToLog($"An error occurred while trying to uninstall OneDrive: {ex.Message}");
                }
            }
        }

        private void brnCreateJson_Click(object sender, EventArgs e)
        {
            string s = WindowsRegistry.GetOneDriveUninstallStringUser();
            if (string.IsNullOrEmpty(s))
            {
                Logging.SendToLog($"OneDrive uninstall string: {s}");
                return;
            }
            else
            {
                Logging.SendToLog($"OneDrive uninstall string: {s}");
                string path = HelperFunctions.ExtractPathFromCommandLine(s);
                Logging.SendToLog($"Path: {path}");
                string args = HelperFunctions.ExtractArgumentsFromCommandLine(s, path);
                Logging.SendToLog($"Args: {args}");

                CustomCommand command = new CustomCommand
                {
                    Command = path,
                    Arguments = args
                };

                // serial command to json and save it in c:\job.json
                string json = Newtonsoft.Json.JsonConvert.SerializeObject(command);
                try
                {
                    if (!Directory.Exists(@"c:\Solvia")) Directory.CreateDirectory(@"c:\Solvia");
                    File.WriteAllText(JobFileJson, json);

                    XmlSerializer serializer = new XmlSerializer(typeof(CustomCommand));
                    using (TextWriter writer = new StreamWriter(JobFileXml))
                    {
                        serializer.Serialize(writer, command);
                    }

                }
                catch (Exception ex)
                {
                    Logging.SendToLog($"An error occurred while trying to create job.json: {ex.Message}");
                }
            }
        }

        private void btnCleanReg_Click(object sender, EventArgs e)
        {
            Logging.SendToLog($"will try to remove {Constants.OneDriveExplorerTree}");
            WindowsRegistry.DeleteRegistryEntry(Microsoft.Win32.RegistryHive.ClassesRoot, Constants.OneDriveExplorerTree);
            Logging.SendToLog("done!");
        }
    }
}
