﻿using System.Diagnostics;
using System;
using System.IO;

namespace SolviaOneDriveKillerLib.Helpers
{
    public class WindowsProcess
    {
        public static int ExecuteCommand(string executablePath, string arguments, bool useShellExecute)
        {
            try
            {
                if(File.Exists(executablePath) == false)
                {
                    Logging.SendToLog($"File not found: {executablePath}");
                    return -1;
                }

                Logging.SendToLog($"Executing command: {executablePath} arguments: {arguments}");
                var processStartInfo = new ProcessStartInfo
                {
                    FileName = executablePath,
                    Arguments = arguments,
                    UseShellExecute = useShellExecute,
                    CreateNoWindow = true
                };

                using (Process process = Process.Start(processStartInfo))
                {
                    process.WaitForExit(); // Wait for the process to complete
                    return process.ExitCode; // Return the exit code of the process
                }
            }
            catch (Exception ex)
            {
                // Log the exception or handle it as needed
                Logging.SendToLog($"ERROR {ex.Message}");
                return -1; // Return a custom exit code indicating failure
            }
        }
    }
}
