﻿using System;
using System.Configuration.Install;
using System.Reflection;
using System.ServiceProcess;
using SolviaOneDriveKillerLib.Helpers;

namespace SolviaOneDriveKiller
{
    internal static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main(string[] args)
        {
            Logging.Log(Logging.LogLevel.Info, "Main method called");
            try
            {
                var serviceToRun = new MainService();
                if (Environment.UserInteractive)
                {
                    string parameter = string.Concat(args);
                    switch (parameter)
                    {
                        case "-install":
                            Console.WriteLine("Install called");
                            ManagedInstallerClass.InstallHelper(new string[] { Assembly.GetExecutingAssembly().Location });
                            break;
                        case "-uninstall":
                            Console.WriteLine("Uninstall called");
                            ManagedInstallerClass.InstallHelper(new string[] { "/u", Assembly.GetExecutingAssembly().Location });
                            break;
                    }
                    serviceToRun.Start(args);
                    Console.WriteLine("Press any key to stop program");
                    Console.Read();
                    serviceToRun.Stop();
                }
                else
                {
                    ServiceBase.Run(serviceToRun);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
    }
}
